function M = CreateCamera( R, T, f, C )
%
%%%%%%%  SINTESI DI UNA CAMERA  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% R: matrice di rotazione [3x3]
% T: vettore traslazione [3x1]
% f: lunghezza focale (in pixel)
% C: posizione del centro ottico [cx,cy]

% A partire da R e T costruisco la matrice estrinseca E
E = [ R T ; 0 0 0 1];

% Costruisco la matrice di calibrazione intrinseca K
K = [f 0 C(1) 0; 0 f C(2) 0; 0 0 1 0];

% Costruisco la matrice di proiezione M, prodotto di K ed E
M = K*E;

