function pim = CameraProj( M, Pw, ImSize)
%
%%%%%%%  Proiezione prospettica di CAMERA  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% M: matrice di proiezione della camera [3x4]
% Pw: punti di scena, in coordinate world [Nx3]
%

% Mediante la matrice M, proietto i punti di scena P
% Passo in coordinate omogenee (che chiamo Ptilde e pimtilde)
%
N = size(Pw,1);              % N: numero di punti di scena
Ptilde = [ Pw ones(N,1)]';   % punti di scena in coordinate omogenee

pimtilde = M * Ptilde;       % proietto

pim = [ pimtilde(1,:)./pimtilde(3,:) ;  pimtilde(2,:)./pimtilde(3,:)]; 
                            % coordinate immagine euclidee

% genero l'immagine degli N punti e
% traccio anche il rettangolo che rappresenta il campo visivo della camera
plot( pim(1,:), pim(2,:), 'b' , ...
      [0;ImSize(1);ImSize(1);0;0], [0;0;ImSize(2);ImSize(2);0], 'r'); 
