# Zaino

param N;             # numero degli oggetti
set Oggetti := 1..N; # insieme degli oggetti

param c {Oggetti} >= 0; # valore di ogni oggetto
param a {Oggetti} >= 0; # volume di ogni oggetto
param b >= 0;           # capacita' dello zaino

# scelta degli oggetti (1 se inserire, 0 se no)
var x {Oggetti} binary;

maximize z : sum{i in Oggetti} c[i] * x[i];

subject to VincoloCapacita :
  sum{i in Oggetti} a[i] * x[i] <= b;

end;
