# Trasporto

param O;  # numero delle origini
param D;  # numero delle destinazioni

set Origini := 1..O;        # insieme delle origini
set Destinazioni := 1..D;   # insieme delle origini

# quantita' offerte
param o {Origini} >= 0;

# quantita' richieste
param d {Destinazioni} >= 0;

# costo unitario di trasporto
param c {Origini,Destinazioni} >= 0;

# quantita' trasportate
var x {Origini,Destinazioni} >= 0;

minimize z : sum{i in Origini, j in Destinazioni} c[i,j] * x[i,j];

subject to VincoloOrigini {i in Origini} :
  sum{j in Destinazioni} x[i,j] = o[i];

subject to VincoloDestinazioni {j in Destinazioni} :
  sum{i in Origini} x[i,j] = d[j];
  
end;
