# Set Covering

param M;             # numero degli utenti
param N;             # numero dei luoghi

set Utenti := 1..M;  # insieme degli utenti
set Luoghi := 1..N;  # insieme dei luoghi
set L {Utenti};      # collezione dei luoghi che coprono ogni utente

param c {Luoghi} >= 0;  # costo di ogni luogo

# scelta dei luoghi (1 se usare, 0 se no)
var x {Luoghi} binary;

minimize z : sum{j in Luoghi} c[j] * x[j];

subject to VincoloCopertura {i in Utenti} :
  sum{j in L[i]} x[j] >= 1;

end;
