# Pianificazione multi-periodo

param M;
set Periodi := 1..M;

param c;     # costo di produzione normale [Euro/pezzo]
param cp;    # costo di produzione extra   [Euro/pezzo]
param s;     # costo di stoccaggio         [Euro/pezzo]
param g;     # giacenza iniziale [pezzi]

param d {Periodi};     # domanda [pezzi/mese]

param Q;               # capacita' produttiva normale [pezzi/mese]
param Qp;              # capacita' produttiva extra   [pezzi/mese]

var x  {Periodi} >= 0; # produzione normale
var xp {Periodi} >= 0; # produzione extra
var y  {Periodi} >= 0; # scorta al termine

maximize z : sum{i in Periodi} (c * x[i] + cp * xp[i] + s * y[i]);

subject to VincoloBilancio {i in Periodi: i > 1} :
  y[i] = y[i-1] + x[i] + xp[i] - d[i];
  
subject to VincoloBilancioIniziale :
  y[1] = g + x[1] + xp[1] - d[1];

subject to VincoloCapacita {i in Periodi} :
  x[i] <= Q;
  
subject to VincoloCapacitaExtra {i in Periodi} :
  xp[i] <= Qp;

end;
