# Dieta

set Sostanze;   # insieme delle sostanze rilevanti

set Alimenti;   # insieme degli alimenti disponibili

# fabbisogno minimo per ogni sostanza [g/giorno]
param LimiteInferiore {Sostanze} >= 0;

# fabbisogno massimo per ogni sostanza [g/giorno]
param LimiteSuperiore {Sostanze} >= 0;

# prezzo per ogni alimento [Euro/kg]
param Prezzo {Alimenti} >= 0;

# contenuto per ogni sostanza di ogni alimento [g/kg]
param Contenuto {Sostanze,Alimenti} >= 0;

# Porzioni giornaliere di ogni alimento [kg]
var x {Alimenti} >= 0;

minimize z : sum{j in Alimenti} Prezzo[j] * x[j];

subject to VincoloInferiore {i in Sostanze} :
  sum{j in Alimenti} Contenuto[i,j] * x[j] >= LimiteInferiore[i];

subject to VincoloSuperiore {i in Sostanze} :
  sum{j in Alimenti} Contenuto[i,j] * x[j] <= LimiteSuperiore[i];
  
end;
