# Containers

param N;                # numero degli oggetti
param M;                # numero dei container

set Oggetti   := 1..N;  # insieme degli oggetti
set Container := 1..M;  # insieme dei container

param p {Oggetti} >= 0;    # peso di ogni oggetto
param P {Container} >= 0;  # capacita' di ogni container
param c {Container} >= 0;  # costo di ogni container

# assegnamento degli oggetti ai container
var x {Oggetti,Container} binary;

# scelta dei container
var y {Container} binary;

minimize z : sum{j in Container} c[j] * y[j];

subject to VincoloAssegnamento {i in Oggetti} :
  sum{j in Container} x[i,j] = 1;

subject to VincoloCapacita {j in Container} :
  sum{i in Oggetti} p[i] * x[i,j] <= P[j] * y[j];

end;
