# Set Covering

param M;             # numero degli utenti
param N;             # numero dei luoghi

set Utenti := 1..M;  # insieme degli utenti
set Luoghi := 1..N;  # insieme dei luoghi

param c {Luoghi} >= 0;                          # costo di ogni luogo
param a {Utenti,Luoghi} >= 0, <= 1, default 0;  # matrice di copertura

# scelta dei luoghi (1 se usare, 0 se no)
var x {Luoghi} binary;

minimize z : sum{j in Luoghi} c[j] * x[j];

subject to VincoloCopertura {i in Utenti} :
  sum{j in Luoghi} a[i,j] * x[j] >= 1;

end;
