# Sentinelle

param N;             # numero degli incroci
set Incroci:= 1..N;  # insieme degli incroci

# matrice della connessione fra incroci
param a {Incroci,Incroci} >= 0, <= 1, default 0; 

# assegnamento degli oggetti ai container
var x {Incroci} binary;

minimize z : sum{i in Incroci} x[i];

subject to VincoloSorveglianza {i in Incroci} :
  sum{j in Incroci} a[i,j] * x[j] >= 1;

end;
