# Posologia

param N;  # numero delle fasce orarie
param F;  # numero dei farmaci

set FasceOrarie := 1..N;
set Farmaci := 1..F;
set Distanze := 0..12;

param c {Farmaci};           # costo del farmaco [Euro/g]
param q {FasceOrarie};       # fabbisogno nelle diverse fasce orarie [mg/cc]
param Q;                     # quantita' massima di proteina ammissibile [mg/cc]
param a {Distanze,Farmaci};  # quantita' generata a una certa distanza 
                             # di tempo da un certo farmaco [mg/cc]

var x  {FasceOrarie,Farmaci} >= 0; # quantita' di farmaco assunta [g]

minimize z : sum{i in FasceOrarie, j in Farmaci} c[j] * x[i,j];

subject to VincoloFabbisogno {i in FasceOrarie} :
  sum{j in Farmaci, k in Distanze} a[k,j] * (if (i > k) then x[i-k,j] else x[N+i-k,j])/1000 >= q[i];

subject to VincoloMassimo {i in FasceOrarie} :
  sum{j in Farmaci, k in Distanze} a[k,j] * (if (i > k) then x[i-k,j] else x[N+i-k,j])/1000 <= Q;

end;
