# Mix produttivo ottimale

set Reparti;
set Modelli;
set Combinazioni within {Reparti,Modelli};

param Capacita {Reparti};
param Profitti {Modelli};
param Tempi {Combinazioni};

# Porzioni giornaliere di ogni alimento [kg]
var x {Modelli} >= 0;

maximize z : sum{j in Modelli} Profitti[j] * x[j];

subject to VincoloTempi {i in Reparti} :
  sum{j in Modelli: (i,j) in Combinazioni} Tempi[i,j] * x[j] <= Capacita[i];
  
end;
