# Esercizio Triangolo vuoto

# DATI
param n;
set P := 1..n;
param x {P};
param y {P};
set T := {i in P, j in P, k in P: (i < j) and (j < k)};
# Calcolo dell'area di ogni triangolo tramite il determinante
param A {(i,j,k) in T} := abs((y[k]-y[i])*(x[j]-x[i])-(x[k]-x[i])*(y[j]-y[i]))/2;
# u[i,j,k] indica se k giace a sx (1) o a dx (-1) della retta orientata da i a j
param epsilon = 0.000001;
param u {i in P, j in P, k in P} := 
  if ((y[k]-y[i])*(x[j]-x[i])-(x[k]-x[i])*(y[j]-y[i]) > epsilon) 
    then 1 
    else if ((y[k]-y[i])*(x[j]-x[i])-(x[k]-x[i])*(y[j]-y[i]) < -epsilon) 
    then -1
    else 0;

# VARIABILI
var tau {T} >=0;			# scelta triangolo

# VINCOLI
# Un triangolo  proibito se contiene almeno un punto
s.t. Vuoto {(i,j,k) in T, h in P: (h not in {i,j,k}) and abs((u[i,j,h]+u[j,k,h]+u[k,i,h]) = 3)}:
  tau[i,j,k] = 0;

# Un solo triangolo pu essere scelto
s.t. Un_triangolo_solo:
  sum {(i,j,k) in T} tau[i,j,k] = 1;

# OBIETTIVO
# Massimizzare l'area del triangolo scelto
maximize Area: sum {(i,j,k) in T} A[i,j,k] * tau[i,j,k];

########################
data;
########################

param n := 7;

param: x    y :=
1      1    7
2      4    1
3      4   10
4      7    6
5      8    6
6      8    3
7     10    8;

end;
    
