# Esercizio Evacuazione con tempi unitari di transito

# DATI
param nN;                   # Numero di stanze
set N := 1..nN+1;           # Set di nodi del grafo
param p0 {N};               # Popolazione iniziale in ogni nodo
set A within N cross N;     # Set di archi del grafo
param cap {A};              # Capacit archi
param Tmax;                 # N. periodi
set T := 1..Tmax;           # Set dei periodi
param c {T};                # Livello di intossicazione per ogni periodo

# VARIABILI
var x {(i,j) in A,T} >=0;	# Flussi che attraversano ogni arco in [t-1,t]
var p {N,T} >=0;			# Presenze in ogni nodo alla fine di ogni intervallo
var y {N,T} >=0;			# Presenze rimaste in ogni nodo alla fine di ogni intervallo
var w {T} binary;           # Uso di un periodo di tempo
var W;                      # Intossicazione massima

# VINCOLI
  
# Vincoli di capacit
s.t. Capacity {(i,j) in A, t in T}:
  x[i,j,t] <= cap[i,j] * w[t];

# Conservazione del flusso in ogni nodo in ogni intervallo > 1
# Pu uscire nell'intervallo t solo chi era gi nella stanza alla fine dell'intervallo t-1
s.t. Flow_cons1 {i in N, t in T: t>1}:
  p[i,t-1] - sum {(i,j) in A} x[i,j,t] = y[i,t];
s.t. Init_Flow1 {i in N}:
  p0[i] - sum {(i,j) in A} x[i,j,1] = y[i,1];
s.t. Flow_cons2 {i in N, t in T}:
  y[i,t] + sum {(j,i) in A} x[j,i,t] = p[i,t];

# Tutti devono uscire entro il periodo T
s.t. Fuori_tutti:
  sum {i in N: i <= nN} p[i,Tmax] = 0;

# OBIETTIVO
# Minimizzare il danno totale
#minimize z: sum {t in T, i in N: (i,nN+1) in A} c[t] * x[i,nN+1,t];
# Minimizzare il danno massimo
minimize z: W;
s.t. minmax {t in T}: W >= t * w[t];

#######################
data;
#######################

param nN := 6;

param p0 :=
1	24
2	13
3	10
4	8
5	18
6	2
7	0;

param: A: cap :=
1   2		4
1   3		2
3   4		5
2   4		4
2   6		3
4   5		2
5   6		4
6   7		4
5   7		4
# Archi in senso opposto a quelli dati, perch le porte sono bidirezionali
2   1		4
3   1		2
4   3		5
4   2		4
6   2		3
5   4		2
6   5		4
7   6		4
7   5		4
;

param Tmax := 12;

param c :=
 1	 0
 2	 1
 3	 3
 4	 6
 5	10
 6	15
 7	30
 8	35
 9	39
10	42
11	44
12	45
;

end;
