# Esercizio PL 13 - Forno

# DATI
set P; 			# insieme degli alimenti
param t{P}; 	# tempo unitario di produzione [h/kg]
param s{P}; 	# spazio unitario occupato [mq/kg]
param m{P}; 	# produzione minima giornaliera [kg]
param p{P}; 	# prezzo di vendita [/kg]
param A; 		# area del forno [mq]
param T; 		# tempo di funzionamento del forno [h]

# VARIABILI
var x{i in P} >= m[i]; # quantit da produrre per ogni alimento [kg]

# VINCOLI
# Risorsa disponibile [mq * h]
subject to Risorsa: 
  sum {i in P} t[i] * s[i] * x[i] <= A * T;

# Vincolo aggiuntivo: nessun prodotto deve essere sfornato in quantit superiore al doppio di un altro
subject to NoDoppio {i in P, j in P: i <> j}: 
  x[i] <= 2 * x[j];

# OBIETTIVO
# Massimizzare i ricavi []
maximize z: sum {i in P} p[i] * x[i];

#################################
data;

set P := Pane Biscotti Focacce Paste;

param:	 	t 		s		m		p :=
Pane        1		1		5		2.50
Biscotti    3		0.2		2		4.00
Focacce     1.5		1.5		3		2.00
Paste       2		1.5		2		5.50;

param A := 4;

param T := 6.25;

end;
