# ----------------------------------------
# CAPACITATED P-MEDIAN PROBLEM
# ----------------------------------------

# Data
set N;				# Nodes of the graph
param p integer;		# N. of medians
param d {N} integer > 0;	# Demand
param s {N} integer > 0;	# Supply
param c {N,N} >= 0;		# Unit transportation cost

# Parameters
param lambda {N} >= 0;   	# Lagrange multipliers for Demand constraints

# Variables
var y {N} binary;    		# y = 1 iff median is located at node i
var x {N,j in N} >= 0, <= d[j];	# amount shipped from a median i to any node j

# Objective
minimize z:
   sum {i in N, j in N} c[i,j] * x[i,j];

# Constraints
subject to Demand {j in N}:
   sum {i in N} x[i,j] >= d[j];

subject to Supply {i in N}:
   sum {j in N} x[i,j] <= s[i];

subject to Disaggregated {i in N, j in N}:
   x[i,j] <= d[j] * y[i];

subject to Limit:
   sum {i in N} y[i] <= p;

# Lagrangean objective function
minimize zLR:
   sum {i in N, j in N} c[i,j] * x[i,j] + sum {j in N} lambda[j] * (d[j] - sum {i in N} x[i,j]);

