# DATA
param n;					# N. of nodes
param m;					# N. of commodities

set V := 1 .. n;			# Nodes
set A within {V cross V};	# Arcs

set K := 1 .. m;			# Commodities

param c {A,K};				# Unit cost for each arc/commodity
param b {V,K};				# Supply (+) or Demand (-) for each node/commodity
param u {A};				# Capacity for each arc

# Lagrange multipliers
param lambda {A} >=0, default 0;

# VARIABLES
var x{(i,j) in A, k in K} >= 0, <= u[i,j];

# OBJECTIVE
minimize z: 
  sum{(i,j) in A, k in K} c[i,j,k] * x[i,j,k];
  
# CONSTRAINTS
# Flow conservation constraints
subject to flowcons{j in V, k in K}: 
  sum{(i,j) in A} x[i,j,k] + b[j,k] = sum{(j,i) in A} x[j,i,k];

# Capacity constraints
subject to cap{(i,j) in A}: 
  sum{k in K} x[i,j,k] <= u[i,j];

# Lagrangean objective function
minimize zLR: 
  sum{(i,j) in A, k in K} c[i,j,k] * x[i,j,k] 
+ sum{(i,j) in A} lambda[i,j] * (sum{k in K} x[i,j,k] - u[i,j]);

# PROBLEMS
# Original problem
problem mmcf: z, flowcons, cap, x;
# Lagrangean subproblems
problem lr_mmcf {k in K}: zLR, {j in V} flowcons[j,k], {(i,j) in A} x[i,j,k];
