function [N,T] = add_tracks(D,SR,ID)
% [N,T] = add_tracks(D,SR,ID)
%    Add one or more tracks to the hashtable database.
%    <D, SR> define the waveform of the track, and ID is its
%    reference ID.
%  add_tracks(N,ID) loads soundfile named N and adds it.
%  add_tracks(A,IDs,skip) loads each soundfile named in 
%    cell array A and adds it with the corresponding element 
%    from IDs (pass [] to use index number as ID).  Optional 
%    skip causes adding to start only from the skip+1th element.
%
%    N returns the total number of hashes added, T returns total
%    duration in secs of tracks added.
%
% 2008-12-29 Dan Ellis dpwe@ee.columbia.edu
%
% 2015: using audioread and isempty, G.Presti.

% Target query landmark density
% (reference is 7 lm/s)
dens = 10;

if isnumeric(D)
  H = landmark2hash(find_landmarks(D,SR,dens),ID);
%  save_hashes(H);
  record_hashes(H);
  N = length(H);
  T = length(D)/SR;
elseif ischar(D)
  if nargin < 3
    ID = SR;
  end
  [D,SR] = audioread(D);
  [N,T] = add_tracks(D,SR,ID);
elseif iscell(D)
  
  disp(['Target density = ',num2str(dens),' hashes/sec']);
  
  nd = length(D);
  if nargin < 3
    skip = 0;
  else
    skip = ID;
  end
  if nargin < 2
    % simulate user entering "don't care" for IDs
    SR = [];
  end
  if isempty(SR)
    % omitting IDs defaults to track number
    ID = 1:nd;
  else
    % ID is second arg
    ID = SR;
  end
  N = 0;
  T = 0;
  for i = (skip+1):nd
    disp(['Adding #',num2str(ID(i)),' ',D{i},' ...']);
    [n,t] = add_tracks(D{i},ID(i));
    N = N + n;
    T = T + t;
  end
  disp(['added ',num2str(nd),' tracks (',num2str(T),' secs, ', ...
        num2str(N),' hashes, ',num2str(N/T),' hashes/sec)']);
else
  error('I cant tell what D is');
end



