%%  Il fingerprinting alla base di Shazam
%
% Method defined in:
% Wang, Avery. "An Industrial Strength Audio Search Algorithm." ISMIR. 2003.
%
% Code based on:
% D. Ellis (2009), "Robust Landmark-Based Audio Fingerprinting", 
% web resource, available: http://labrosa.ee.columbia.edu/matlab/fingerprint/
%
% Thanks to:
% Prof. Michele Scarpiniti, Dipartimento di Ingegneria dell'Informazione, 
% Elettronica e Telecomunicazioni "Sapienza" Universit di Roma (2015)
%
% Slightly adapted by:
% Dott. Giorgio Presti, Laboratorio di Informatica Musicale, Universit
% degli Studi di Milano, Dipartimento di Informatica (2016)
%
% Course:
% Database Multimediali, by Prof. Paolo Perlasca

%% Server side: Setup-time
% Carico il datased di brani tra cui effettuare la ricerca
addpath('./lib/');
path = './dataset/';
filetype = '*.mp3';
tracks = listfiles(path, filetype);

% Creo la tabella degli hash del mio dataset come variabile globale
% (scelta di comodo, in un contesto realistico sarebbe un database)
tic
nhashes     = 2^20; 
maxnentries = 100;
init_hashtable(nhashes, maxnentries); % 1M hash x 32 bit x 100 ent = 400MB

% Per vedere le variabili della hashtable nel workspace:
% global HashTable HashTableCounts

% Popolo la tabella con le tracce del dataset
add_tracks(tracks);
fprintf('\nTempo impiegato per la creazione della hashtable: %f secondi.\n\n',toc);
%% Client side
% A questo punto un utente registra un frammento e lo invia al server
[x,Fs] = audioread('Q-full-circle.mp3');

%% Server side: Run-time
% Eseguo la query sul dataset
tic
results = match_query(x,Fs);

% Le informazioni sul match sono contenute in results. La matrice 
% ordinata in modo da avere sulla prima riga i dati sul miglior match:
fprintf(['\nMigliore match:\n ID Brano:\t\t\t%i\n Matching peaks:\t%i\n ' ... 
         'Offset frames:\t\t%i\n Matching hashes:\t%i\n\n'], ...
         results(1,1),results(1,2),results(1,3),results(1,4));

% Dall'indice della traccia posso risalire al titolo del brano da inviare all'utente:
[pth,nam,ext] = fileparts(tracks{results(1,1)});
fprintf('Il brano cercato : %s\n\n', [nam ext]);
fprintf('Tempo impiegato per la ricerca: %f secondi.\n\n',toc);
%% Plot dei match:
illustrate_match(x,Fs,tracks);
colormap(1-gray)
