% Analysis of hand-written digits
% Analyze the digits data using a SOM, in some suitable way 
% Could you obtain separated clusters for different digits?
% Load images from digits directory and targets from digit_names.mat (download from https://homes.di.unimi.it/munoz/teaching.html)

close all
clear variables

load('digits_names.mat');
files=dir('digits/*.bmp');
for i=1:numel(files)    
    im=imread(['digits/' files(i).name]);    
    P(:,i)=double(reshape(im,[1,35]));    
    for j=1:numel(names)
        if strcmp(files(i).name,names{j})
           [~,T(i)]=max(targetsByName(:,j));
           break;
        end
    end
end

figure                                          % plot images
for i = 1:10                                    
    subplot(2,5,i)                              
    digit = reshape(P(:, i), [7,5]);    
    imshow(digit,[])    
   
    if (T(i)~=10)
        title(num2str(T(i)));
    else
        title(num2str(0));
    end
end

orderingEpochs=100;
initialNeigborhoodSize=5;
totalEpochs=200;
som = selforgmap([5 5],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,P);

figure;
plotsomhits(som, P(:,T==1)) 
title('samples digit 1');
figure;
plotsomhits(som, P(:,T==2)) 
title('samples digit 2');
figure;
plotsomhits(som, P(:,T==3))
title('samples digit 3');
figure;
plotsomhits(som, P(:,T==4))
title('samples digit 4');
figure;
plotsomhits(som, P(:,T==5))
title('samples digit 5');
figure;
plotsomhits(som, P(:,T==6))
title('samples digit 6');
figure;
plotsomhits(som, P(:,T==7))
title('samples digit 7');
figure;
plotsomhits(som, P(:,T==8))
title('samples digit 8');
figure;
plotsomhits(som, P(:,T==9))
title('samples digit 9');
figure;
plotsomhits(som, P(:,T==10))
title('samples digit 0');
