% Analysis unknown data
% Load unknown_data, it contains a matrix and 5 points (https://homes.di.unimi.it/munoz/teaching.html)
% Analyze the unknown_data using a SOM, in some suitable way 
% How many well-separated clusters are there in the data set? 
% Which data points are from the same cluster? 

close all
clear variables

rng(1234);

load unknown_data.mat

orderingEpochs=300;
initialNeigborhoodSize=5;
totalEpochs=600;
som = selforgmap([10 10],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,unknown_data);

plotsomhits(som, point1) 
title('Point 1');
figure
plotsomhits(som, point2) 
title('Point 2');
figure
plotsomhits(som, point3)
title('Point 3');
figure
plotsomhits(som, point4)
title('Point 4');
figure
plotsomhits(som, point5)
title('Point 5');
