% Analysis of flower data 
% Load iris_dataset (included in Matlab)
% Create and train a 10x10-node SOM with suitable parameters
% Study the class separation using sample hits plots (Iris Setosa (samples 1-50), Iris Versicolour (samples 51-100) and Iris Virginica (samples 101-150))
% Analyze SOM Neighbor Distances, does any evidence indicate that data are not from a single species? 
% Analyze SOM Weight Planes, Does any attribute seem particularly correlated? 

close all
clear variables

rng(1234);

load iris_dataset.mat

orderingEpochs=300;
initialNeigborhoodSize=5;
totalEpochs=600;
som = selforgmap([10 10],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,irisInputs);

figure,
plotsomhits(som, irisInputs(:,1:50)) 
figure
plotsomhits(som, irisInputs(:,51:100)) 
figure
plotsomhits(som, irisInputs(:,101:150))
