% Training with normalized data
% Normalize the data using Matlab function mapminmax
% Retrain the 5x5 and the 10x10-node SOMs
% How well do the two SOMs separate the classes in the normalizeddata? 

close all
clear variables

rng(1234);

load wine_dataset

wineInputs = mapminmax(wineInputs);

orderingEpochs=200;
initialNeigborhoodSize=7;
totalEpochs=400;
som = selforgmap([10 10],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,wineInputs);

plotsomhits(som, wineInputs(:,1:59)) 
figure
plotsomhits(som, wineInputs(:,60:130)) 
figure
plotsomhits(som, wineInputs(:,131:178))


orderingEpochs=200;
initialNeigborhoodSize=5;
totalEpochs=400;
som = selforgmap([5 5],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,wineInputs);

figure
plotsomhits(som, wineInputs(:,1:59)) 
figure
plotsomhits(som, wineInputs(:,60:130)) 
figure
plotsomhits(som, wineInputs(:,131:178))