% Repeat the same procedure as with a 10x10-node SOM
% What training parameters did you use? What major differences do you see 
% in the results compared to the 5x5-node SOM? 


close all
clear variables

rng(1234);

load wine_dataset

orderingEpochs=200;
initialNeigborhoodSize=7;
totalEpochs=400;
som = selforgmap([10 10],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,wineInputs);

figure
plotsomhits(som, wineInputs(:,1:59)) 
figure
plotsomhits(som, wineInputs(:,60:130)) 
figure
plotsomhits(som, wineInputs(:,131:178))
