% Try to optimize the parameters of the SOM to reduce overlap
% What training parameters did you use? How well does the trained SOM separate 
% the classes in your opinion? Is some class easier to separate than the rest? 


close all
clear variables

rng(1234);

load wine_dataset

orderingEpochs=200;
initialNeigborhoodSize=5;
totalEpochs=400;
som = selforgmap([5 5],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,wineInputs);

figure
plotsomhits(som, wineInputs(:,1:59)) 
figure
plotsomhits(som, wineInputs(:,60:130)) 
figure
plotsomhits(som, wineInputs(:,131:178))
