% Study activations with models trained using some other dataset (e.g. train using P10, test using P30)
% What is the response of a network that is trained on a data set
% with a large standard deviation, when used on a data set with a small standard deviation? Why? 
% What is the response of a network that is trained on a data set
% with a small standard deviation, when used on a data set with a large standard deviation? Why?


clear variables;
close all;

rng(1234)

load sphere_data.mat;

scatter3(P10(1,:),P10(2,:),P10(3,:)); 
hold on
scatter3(P20(1,:),P20(2,:),P20(3,:),'+k');
scatter3(P30(1,:),P30(2,:),P30(3,:),'*r');

som = selforgmap([10 10],100,5,'hextop','linkdist');

[som_P10, stats] = train(som, P10);
[som_P20, stats] = train(som, P20);
[som_P30, stats] = train(som, P30);

figure
plotsomhits(som_P10, P30(:,1:100)) 
title('cluster 1 trained using P10, tested P30');
figure
plotsomhits(som_P10, P30(:,101:200)) 
title('cluster 2 trained using P10, tested P30');


figure
plotsomhits(som_P20, P10(:,1:100)) 
title('cluster 1 trained using P30, tested P10');
figure
plotsomhits(som_P20, P10(:,101:200)) 
title('cluster 2 trained using P30, tested P10');
