% Study overlap of activations for two clusters
% Train two models, one using P20 and the other using P30 (included in sphere_data, download from https://homes.di.unimi.it/munoz/teaching.html)
% Use plotsomhits to study overlap (you can use the code in example1)
% What amount of overlapping do you see for each different data set? 

clear variables;
close all;

load sphere_data.mat;

scatter3(P30(1,:),P30(2,:),P30(3,:));

som = selforgmap([10 10],100,5,'hextop','linkdist');

[som_P30, stats] = train(som, P30);

figure
plotsomhits(som_P30, P30(:,1:100)) % Winning nodes for F1.
figure
plotsomhits(som_P30, P30(:,101:200)) % Winning nodes for F2.

