% Study overlap of activations for two clusters
% Train two models, one using P20 and the other using P30 (included in sphere_data, download from https://homes.di.unimi.it/munoz/teaching.html)
% Use plotsomhits to study overlap (you can use the code in example1)
% What amount of overlapping do you see for each different data set? 


clear variables;
close all;

load sphere_data.mat;

scatter3(P20(1,:),P20(2,:),P20(3,:));

som = selforgmap([10 10],100,5,'hextop','linkdist');

[som_P20, stats] = train(som, P20);

figure
plotsomhits(som_P20, P20(:,1:100)) % Winning nodes for F1.
figure
plotsomhits(som_P20, P20(:,101:200)) % Winning nodes for F2.

