% Obtain the optimal number of hospitals in example 4
% Try different values for k
% Evaluate the solutions obtained using objective function 
% [idx, C, sumd] = kmeans(points, numberOfClusters);
% Evaluate the solutions obtained using mean Silhouette values 
% [silh,h] = silhouette(points,idx);
% mean(silh)
% Which value of k obtains better performance with each measure?

clear variables;
close all;

rng(1234);

%load clustering db
load('points.mat');

%plot points
scatter(points(:,1),points(:,2));

maxNumberOfCluster=20;

for i=2:20
    numberOfClusters=i;
    % apply k-means algorithm
    [idx,C,sumd]=kmeans(points,numberOfClusters);
    sumDs(i)=mean(sumd);
    
    
    
    %analyze results with silhouette value
    [silh,h] = silhouette(points,idx);
    
    eval(numberOfClusters)=mean(silh);
    
end

figure, plot(sumDs(2:end));
title('objective function');
xlabel('number of clusters');
ylabel('objective function');
figure, plot(eval(2:end));
title('mean silhouette');
xlabel('number of clusters');
ylabel('mean silhouette');


%plot results
figure,
scatter(points(:,1),points(:,2),[],idx);
hold on;
scatter(C(:,1),C(:,2),40,1:numberOfClusters,'^','filled');