% Segment an image
% Use fuzzy C-Means to separate background and foreground from an image


close all
clear all
 
rng(1234);

%load image
img = imread('cellula.jpg');
 
% fuzzy C-Means Clustering requires double 
img = im2double(img);
 
figure
imshow(img)
title('Input image')
 
% color channels
R = img(:,:,1);
G = img(:,:,2);
B = img(:,:,3);
 
figure
subplot(1,3,1)
imshow(R)
title('R')
subplot(1,3,2)
imshow(G)
title('G')
subplot(1,3,3)
imshow(B)
title('B')


% feature matrix
vColors = [R(:), G(:), B(:)]; 
 
% C-Means Clustering 
[center, U, obj_fcn] = fcm(vColors ,3);


cluster1Image=reshape(U(1,:), size(img,1), size(img,2));
cluster2Image=reshape(U(2,:), size(img,1), size(img,2));
cluster3Image=reshape(U(3,:), size(img,1), size(img,2));

figure
subplot(1,4,1);
imshow(img);
subplot(1,4,2);
imshow(cluster1Image,[]);
subplot(1,4,3);
imshow(cluster2Image,[]);
subplot(1,4,4);
imshow(cluster3Image,[]);

 
% % Search the most probable class
% [maxU, clusterID] = max(U);
%  
% % Map the obtain vector in the two-dimensional space
% ClusterizedImg = reshape(clusterID, size(img,1), size(img,2));
%  
% figure
% subplot(1,4,1)
% imshow(img)
% title('Input image')
% subplot(1,4,[2 3 4])
% imshow(ClusterizedImg,[])
% title('Cluster image')
% colormap('jet')
% colorbar
