% Cluster foods according to preference correlations
% 42 individuals were asked to order 15 breakfast items due to their preference
% Cluster breakfast data into three clusters, to represent cluster membership in RGB color space
% Analyze the visual results


clear variables
close all

rng(1234);

load breakfast.mat

[centers,U] = fcm(breakfast,3,[2.0 2000 1e-15 true]);

load breakfast_labels.mat

for i=1:numel(labels)
    label=labels{i};
    position=labelPositions(i,:);
    text(position(1),position(2),...
       label,...
       'HorizontalAlignment','center',... 
       'BackgroundColor',[U(3,i) U(2,i) U(1,i)], 'Color',[1 1 1])
    
end

xlim([-1 1]);
ylim([-1 1]);

[idx,C] = kmeans(breakfast,3);

for i=1:numel(labels)
    label=labels{i};
    position=labelPositions(i,:);
    if idx(i)==1
        color=[1 0 0];
    elseif idx(i)==2
        color=[0 1 0];
    else
        color=[0 0 1];
    end
    text(position(1),position(2),...
       label,...
       'HorizontalAlignment','center',... 
       'BackgroundColor',color, 'Color',[1 1 1])
    
end

xlim([-1 1]);
ylim([-1 1]);