% Analysis of wine data
% Analyze how SOMs can differentiate classes with unsupervised learning
% Study overlapping of neuron activations
% Create a 5x5 node SOM with hextop topology and linkdist distance

close all
clear variables

rng(1234);

load wine_dataset

orderingEpochs=100;
initialNeigborhoodSize=5;
totalEpochs=200;
som = selforgmap([5 5],orderingEpochs,initialNeigborhoodSize,'hextop','linkdist');

som.trainParam.epochs=totalEpochs;

[som,tr] = train(som,wineInputs);

plotsomhits(som, wineInputs(:,1:59)) 
figure
plotsomhits(som, wineInputs(:,60:130)) 
figure
plotsomhits(som, wineInputs(:,131:178))
