% Training on simple 3-dimensional data 
% Use a SOM to map a 3-D space (input) into a 2-D space (SOM grid)
% Data: 
% Included in sphere_data.mat (https://homes.di.unimi.it/munoz/teaching.html)
% Points given by their Cartesian coordinates (x; y; z), that lie on the unit sphere (x2 + y2 + z2 = 1)
% Form two clusters:
% Cluster 1: samples from 1:100
% Cluster 2: samples from 101:200


clear variables;
close all;

load sphere_data.mat;

scatter3(P10(1,:),P10(2,:),P10(3,:));

som = selforgmap([10 10],200,5,'hextop','linkdist');

[som_P10, stats] = train(som, P10);

figure
plotsomhits(som_P10, P10(:,1:100)) % Winning nodes for F1.
figure
plotsomhits(som_P10, P10(:,101:200)) % Winning nodes for F2.

figure
plotsom(som_P10.iw{1,1}, som_P10.layers{1}.distances)
hold on
plot3(P10(1,:), P10(2,:), P10(3,:), '+k')
