% Help deciding where to place hospitals
% We have a matrix with coordinates of emergency calls
% Decide the best position for 3 hospitals that minimizes the distance from 
% all the points of a particular cluster


clear variables;
close all;

numberOfClusters=5;

%load clustering db
load('points.mat');

%plot points
scatter(points(:,1),points(:,2));

% apply k-means algorithm
[idx,C]=kmeans(points,numberOfClusters);

%plot results
scatter(points(:,1),points(:,2),[],idx);
hold on;
scatter(C(:,1),C(:,2),40,1:numberOfClusters,'^','filled');

%analyze results with silhouette value
figure
[silh,h] = silhouette(points,idx);