% Mapping of RGB color data
% Create a mapping from 3 to 2 dimensions
% Analyze how SOMs preserve the topology of the data
% Data:
% Included in rgb_data.mat (https://homes.di.unimi.it/munoz/teaching.html)
% Colors are represented using red, green and blue components, ranging from 0 (no color) to 1 (full color)

clear variables;
close all;

rng(1234);

load rgb_data

for i=1:64
    for j=1:64
        c=RGB(:,(i-1)*64+j);
        rectangle('Position', [i, j, 1, 1], 'FaceColor', c);
    end
end

orderingEpochs=50;
initialNeigborhoodSize=15;
totalEpochs=100;
net = selforgmap([10 10],orderingEpochs,initialNeigborhoodSize,'gridtop','linkdist');
net.trainParam.epochs=totalEpochs;

[net,tr] = train(net,RGB);

plot_colors(net)

title(sprintf('%i ordering epochs, %i total epochs, %i inital neighborhood size',orderingEpochs,totalEpochs,initialNeigborhoodSize));

savefig(sprintf('%i_%i_%i.fig',orderingEpochs,totalEpochs,initialNeigborhoodSize));
