% RandStream.setGlobalStream (RandStream ('mrg32k3a','Seed', 1234));
close all
clear variables

[x,t] = thyroid_dataset;
size(x)
size(t)

P = x;
T = t;
numClasses=3;
k=10;


%Neural network parameters
neuronsXLayer = 5; % number of neurons per layer
neuronTopology{1} = 'tansig';

indices = crossvalind('Kfold', size(T ,2),k);

kFoldTrainResults = [];
kFoldTestResults = [];
kFoldTotalResults = [];

kFoldTrainTs = [];
kFoldTestTs = [];
kFoldTotalTs = [];

for i =1:k
    
    P_train=P(:,indices ~=i);
    T_train=T(:,indices ~=i);
    P_test=P(:,indices ==i);
    T_test=T(:,indices ==i);
        
    
    net = feedforwardnet(neuronsXLayer);
    
    % training and testing data
    net.divideParam.trainRatio = 1;
    net.divideParam.testRatio  = 0;
    net.divideParam.valRatio   = 0;
    
    net.trainParam.epochs = 100;
    net.trainParam.goal = 0.01;
    for iL = 1: size(neuronsXLayer,2)
        net.layers{iL}.transferFcn = neuronTopology{iL};
    end
    
    
    % train a neural network
    [net,tr,Y,E] = train(net,P_train,T_train);
    
    
    % Training and testing data
    trainResult = net(P_train);
    [maxValueTrain,trainResult] = max(trainResult);
    [~,expectedTrainResult]=max(T_train);
    
    testResultMultiNeuron = net(P_test);
    [maxValueTest,testResult] = max(testResultMultiNeuron);
    [~,expectedTestResult]=max(T_test);
    
    kFoldTrainResults=[kFoldTrainResults, trainResult];
    kFoldTestResults=[kFoldTestResults, testResult];
    kFoldTotalResults=[kFoldTotalResults, trainResult, testResult];
    
    kFoldTrainTs=[kFoldTrainTs, expectedTrainResult];
    kFoldTestTs=[kFoldTestTs, expectedTestResult];
    kFoldTotalTs=[kFoldTotalTs, expectedTrainResult, expectedTestResult];
    
    
end

kFoldTrainErrors=kFoldTrainTs~=kFoldTrainResults;
kFoldTestErrors=kFoldTestTs~=kFoldTestResults;
kFoldTotalErrors=kFoldTotalTs~=kFoldTotalResults;

kFoldTrainErrorRate=mean(kFoldTrainErrors)*100;
kFoldTestErrorRate=mean(kFoldTestErrors)*100;
kFoldTotalErrorRate=mean(kFoldTotalErrors)*100;

fprintf('\nRESULTS \n')
fprintf('TRAINING\n')
fprintf('Error rate = %6.2f %% \n', kFoldTrainErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTrainErrorRate)
fprintf('TESTING\n')
fprintf('Error rate = %6.2f %%  \n', kFoldTestErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTestErrorRate)
fprintf('TOTAL\n')
fprintf('Error rate = %6.2f %% \n', kFoldTotalErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTotalErrorRate)

% Confusion matrix
cm=confusionmat(kFoldTestTs,kFoldTestResults);

fprintf('Test confusion matrix \n\n')
cm



