% Hand-written digit classification
% Train a neural classifier to classify hand-written digits
% 35 features (5x7 grayscale image)
% 10 classes (0, , 9)
% Optimize parameters to minimize 10-fold cross validation error
% Load digit_mini.mat (download from https://homes.di.unimi.it/munoz/teaching.html)


close all
clear variables

load('digits_names.mat');

files=dir('digits/*.bmp');

for i=1:numel(files)    
    im=imread(['digits/' files(i).name]);    
    P(:,i)=double(reshape(im,[1,35]));    
    for j=1:numel(names)
        if strcmp(files(i).name,names{j})
           T(:,i)=targetsByName(:,j);
           break;
        end
    end
end




figure                                          % plot images
for i = 1:10                                    
    subplot(2,5,i)                              
    digit = reshape(P(:, i), [7,5]);    
    imshow(digit,[])    
    [~,expectedTrainResult]=max(T(:,i));
    if (expectedTrainResult==10)
        expectedTrainResult=0;
    end
    title(num2str(expectedTrainResult));                   
end

numClasses=10;
k=10;


%Neural network parameters
neuronsXLayer = 10; % number of neurons per layer
neuronTopology{1} = 'tansig';
neuronTopology{2} = 'tansig';

indices = crossvalind('Kfold', size(T,2) ,k);

kFoldTrainResults = [];
kFoldTestResults = [];
kFoldTotalResults = [];

kFoldTrainTs = [];
kFoldTestTs = [];
kFoldTotalTs = [];

for i =1:k
    
    P_train=P(:,indices ~=i);
    T_train=T(:,indices ~=i);
    P_test=P(:,indices ==i);
    T_test=T(:,indices ==i);
        
    
    net = feedforwardnet(neuronsXLayer);
    
    % training and testing data
    net.divideParam.trainRatio = 1;
    net.divideParam.testRatio  = 0;
    net.divideParam.valRatio   = 0;
    
    net.trainParam.epochs = 100;
    net.trainParam.goal = 0.01;
    for iL = 1: size(neuronsXLayer,2)
        net.layers{iL}.transferFcn = neuronTopology{iL};
    end
    
    
    % train a neural network
    [net,tr,Y,E] = train(net,P_train,T_train);
    
    
    % Training and testing data
    trainResult = net(P_train);
    [maxValueTrain,trainResult] = max(trainResult);
    [~,expectedTrainResult]=max(T_train);
    
    testResultMultiNeuron = net(P_test);
    [maxValueTest,testResult] = max(testResultMultiNeuron);
    [~,expectedTestResult]=max(T_test);
    
    kFoldTrainResults=[kFoldTrainResults, trainResult];
    kFoldTestResults=[kFoldTestResults, testResult];
    kFoldTotalResults=[kFoldTotalResults, trainResult, testResult];
    
    kFoldTrainTs=[kFoldTrainTs, expectedTrainResult];
    kFoldTestTs=[kFoldTestTs, expectedTestResult];
    kFoldTotalTs=[kFoldTotalTs, expectedTrainResult, expectedTestResult];
    
    
end

kFoldTrainErrors=kFoldTrainTs~=kFoldTrainResults;
kFoldTestErrors=kFoldTestTs~=kFoldTestResults;
kFoldTotalErrors=kFoldTotalTs~=kFoldTotalResults;

kFoldTrainErrorRate=sum(kFoldTrainErrors)/size(kFoldTrainErrors,2)*100;
kFoldTestErrorRate=sum(kFoldTestErrors)/size(kFoldTestErrors,2)*100;
kFoldTotalErrorRate=sum(kFoldTotalErrors)/size(kFoldTotalErrors,2)*100;

fprintf('\nRESULTS \n')
fprintf('TRAINING\n')
fprintf('Error rate = %6.2f %%\n', kFoldTrainErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTrainErrorRate)
fprintf('TESTING\n')
fprintf('Error rate = %6.2f %%\n', kFoldTestErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTestErrorRate)
fprintf('TOTAL\n')
fprintf('Error rate = %6.2f %%\n', kFoldTotalErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTotalErrorRate)

% Confusion matrix
cm=confusionmat(kFoldTestTs,kFoldTestResults);

fprintf('Test confusion matrix \n\n')
cm