% Calculate the performance of the neural network developed for exercise 3 using:
% Hold out
% 5-fold cross validation
% 10-fold cross validation
% Leave-one-out cross validation

close all
clear variables

[x,t] = crab_dataset;
size(x)
size(t)

P = x;
T = t(1,:);
numClasses=2;


% Neural network parameters
neuronsXLayer = 5; % number of neurons per layer
neuronTopology{1} = 'tansig';

LOOTrainResults = [];
LOOTestResults = [];
LOOTotalResults = [];

LOOTrainTs = [];
LOOTestTs = [];
LOOTotalTs = [];
for i =1:size(T,2)
    
    P_train=P(:,[1:i-1 i+1:end]);
    T_train=T(:,[1:i-1 i+1:end]);
    P_test=P(:,i);
    T_test=T(:,i);
        
    
    net = feedforwardnet(neuronsXLayer);
    
    % training and testing data
    net.divideParam.trainRatio = 1;
    net.divideParam.testRatio  = 0;
    net.divideParam.valRatio   = 0;
    
    net.trainParam.epochs = 100;
    net.trainParam.goal = 0.01;
    for iL = 1: size(neuronsXLayer,2)
        net.layers{iL}.transferFcn = neuronTopology{iL};
    end
    
    
    % train a neural network
    [net,tr,Y,E] = train(net,P_train,T_train);
    
    
    % Training and testing data
    trainResult = net(P_train);
    trainResult = round(trainResult);
    trainResult(trainResult<0)=0;
    trainResult(trainResult>numClasses-1)=numClasses-1;
    
    
    testResult = net(P_test);
    testResult=round(testResult);
    testResult(testResult<0)=0;
    testResult(testResult>numClasses-1)=numClasses-1;
    
    LOOTrainResults=[LOOTrainResults, trainResult];
    LOOTestResults=[LOOTestResults, testResult];
    LOOTotalResults=[LOOTotalResults, trainResult, testResult];
    
    LOOTrainTs=[LOOTrainTs, T_train];
    LOOTestTs=[LOOTestTs, T_test];
    LOOTotalTs=[LOOTotalTs, T_train, T_test];
    
end

LOOTrainErrors=LOOTrainTs~=LOOTrainResults;
LOOTestErrors=LOOTestTs~=LOOTestResults;
LOOTotalErrors=LOOTotalTs~=LOOTotalResults;

LOOTrainErrorRate=sum(LOOTrainErrors)/size(LOOTrainErrors,2)*100;
LOOTestErrorRate=sum(LOOTestErrors)/size(LOOTestErrors,2)*100;
LOOTotalErrorRate=sum(LOOTotalErrors)/size(LOOTotalErrors,2)*100;

fprintf('\nRESULTS \n')
fprintf('TRAINING\n')
fprintf('Error rate = %6.2f %%\n', LOOTrainErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-LOOTrainErrorRate)
fprintf('TESTING\n')
fprintf('Error rate = %6.2f %%\n', LOOTestErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-LOOTestErrorRate)
fprintf('TOTAL\n')
fprintf('Error rate = %6.2f %%\n', LOOTotalErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-LOOTotalErrorRate)

% Confusion matrix
cm=confusionmat(LOOTestTs,LOOTestResults);

fprintf('Test confusion matrix \n\n')
cm



