
% Calculate the performance of the neural network developed for exercise 3 using:
% Hold out
% 5-fold cross validation
% 10-fold cross validation
% Leave-one-out cross validation


close all
clear variables

[x,t] = crab_dataset;
size(x)
size(t)

P = x;
T = t(1,:);
numClasses=2;
k=10;


%Neural network parameters
neuronsXLayer = 5; % number of neurons per layer
neuronTopology{1} = 'tansig';

indices = crossvalind('Kfold', size(T,2) ,k);

kFoldTrainResults = [];
kFoldTestResults = [];
kFoldTotalResults = [];

kFoldTrainTs = [];
kFoldTestTs = [];
kFoldTotalTs = [];

for i =1:k
    
    P_train=P(:,indices ~=i);
    T_train=T(:,indices ~=i);
    P_test=P(:,indices ==i);
    T_test=T(:,indices ==i);
        
    
    net = feedforwardnet(neuronsXLayer);
    
    % training and testing data
    net.divideParam.trainRatio = 1;
    net.divideParam.testRatio  = 0;
    net.divideParam.valRatio   = 0;
    
    net.trainParam.epochs = 100;
    net.trainParam.goal = 0.01;
    for iL = 1: size(neuronsXLayer,2)
        net.layers{iL}.transferFcn = neuronTopology{iL};
    end
    
    
    % train a neural network
    [net,tr,Y,E] = train(net,P_train,T_train);
    
    
    % Training and testing data
    trainResult = net(P_train);
    trainResult = round(trainResult);
    trainResult(trainResult<0)=0;
    trainResult(trainResult>numClasses-1)=numClasses-1;
    
    
    testResult = net(P_test);
    testResult=round(testResult);
    testResult(testResult<0)=0;
    testResult(testResult>numClasses-1)=numClasses-1;
    
    kFoldTrainResults=[kFoldTrainResults, trainResult];
    kFoldTestResults=[kFoldTestResults, testResult];
    kFoldTotalResults=[kFoldTotalResults, trainResult, testResult];
    
    kFoldTrainTs=[kFoldTrainTs, T_train];
    kFoldTestTs=[kFoldTestTs, T_test];
    kFoldTotalTs=[kFoldTotalTs, T_train, T_test];
    
    
end

kFoldTrainErrors=kFoldTrainTs~=kFoldTrainResults;
kFoldTestErrors=kFoldTestTs~=kFoldTestResults;
kFoldTotalErrors=kFoldTotalTs~=kFoldTotalResults;

kFoldTrainErrorRate=sum(kFoldTrainErrors)/size(kFoldTrainErrors,2)*100;
kFoldTestErrorRate=sum(kFoldTestErrors)/size(kFoldTestErrors,2)*100;
kFoldTotalErrorRate=sum(kFoldTotalErrors)/size(kFoldTotalErrors,2)*100;

fprintf('\nRESULTS \n')
fprintf('TRAINING\n')
fprintf('Error rate = %6.2f %%\n', kFoldTrainErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTrainErrorRate)
fprintf('TESTING\n')
fprintf('Error rate = %6.2f %%\n', kFoldTestErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTestErrorRate)
fprintf('TOTAL\n')
fprintf('Error rate = %6.2f %%\n', kFoldTotalErrorRate)
fprintf('Classification accuracy = %6.2f %%\n', 100-kFoldTotalErrorRate)

% Confusion matrix
cm=confusionmat(kFoldTestTs,kFoldTestResults);

fprintf('Test confusion matrix \n\n')
cm



