close all, clear variables;

RandStream.setGlobalStream (RandStream ('mrg32k3a','Seed', 1234));

% Load and analyze data

load('bodyfat_dataset.mat');
 
 
% P & T 

% INPUT vector
P = bodyfatInputs;
% TARGET vector
T = bodyfatTargets;
 
% divide dataset into training and test

[trainInd,valInd,testInd] = dividerand(size(P,2),0.7,0,0.3);

P_train=P(:,trainInd);
T_train=T(:,trainInd);
P_test=P(:,testInd);
T_test=T(:,testInd);
 
% Create a neural network and tune parameters
  
% create a neural network
neuronsXLayer = 30; % number of neurons per layer
neuronTopology{1} = 'logsig';
% neuronTopology{2} = 'logsig';
% neuronTopology{3} = 'logsig';
% neuronTopology{4} = 'logsig';
% neuronTopology{1} = 'tansig';


net = feedforwardnet(neuronsXLayer);

net.trainParam.epochs = 1000;
net.trainParam.goal = 0.00001;
for iL = 1: size(neuronsXLayer,2)
    net.layers{iL}.transferFcn = neuronTopology{iL}; 
end
  
 
% Divide the input dataset into two subsets


%------------------------------------------
net.divideParam.trainRatio = 1; 
net.divideParam.testRatio  = 0; 
net.divideParam.valRatio   = 0;
%------------------------------------------
 
% Train the created neural network and analyze the results

 
% train a neural network
net = train(net,P_train,T_train);
  
 
% Compute the training and testing results
  
% Training and testing data
trainResult = net(P_train);
 
testResult = net(P_test);

% Plot the results

 
%plot
figure,
plot(T_train)
hold on
plot(trainResult, '--r')
title('training results')
 
figure,
plot(T_test)
hold on
plot(testResult, '--r')
title('testing results')
 


% Compute the error using the required figures of metric
 
 
errorT = abs(T_train - trainResult);
errorV = abs(T_test - testResult);
 

 
% Compute figures of merit
 
%Results
disp(' ---------------------------------------------------------')
disp(' -----TRAINIG ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',mean(errorT));
disp(' -----VALIDATION ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',mean(errorV));
disp(' ---------------------------------------------------------')