close all, clear variables;
RandStream.setGlobalStream (RandStream ('mrg32k3a','Seed', 1234));

load('doll.mat');

figure
tri = delaunay(P(1,:),P(2,:));
h = trisurf(tri, P(1,:), P(2,:), T);
% axis vis3d

[trainInd,valInd,testInd] = dividerand(size(P,2),0.7,0,0.3);

P_train=P(:,trainInd);
T_train=T(:,trainInd);
P_test=P(:,testInd);
T_test=T(:,testInd);

goal=0.5; spread= 10;  
net1 = newrb(P_train,T_train,goal,spread); 

trainResult=net1(P_train);
testResult=net1(P_test);

errorT = abs(T_train - trainResult);
errorV = abs(T_test - testResult);

% Compute figures of merit
 
%Results
disp(' ---------------------------------------------------------')
disp(' -----TRAINIG ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',mean(errorT));
disp(' -----VALIDATION ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',mean(errorV));
disp(' ---------------------------------------------------------')

figure,
scatter3(P_train(1,:),P_train(2,:),T_train)
hold on
scatter3(P_train(1,:),P_train(2,:),trainResult)
legend('Real data', 'RBF estimation');
