close all, clear variables

RandStream.setGlobalStream (RandStream ('mrg32k3a','Seed', 1234));
% Load and analyze data

load('2Ddata.mat ');
 
% minimum and maximum of the "enzymes"
[min(X_train')' max(X_train')']

% Create a neural network and tune parameters
 
% create a neural network
neuronsXLayer = [15,15,15]; % number of neurons per layer

% neuronTransferFcn{1} = 'logsig';
neuronTransferFcn{1} = 'tansig';
neuronTransferFcn{2} = 'tansig';
neuronTransferFcn{3} = 'tansig';
% neuronTransferFcn{2} = 'purelin';
 
 
net_ff = feedforwardnet(neuronsXLayer);
 
 
% training and testing data
net_ff.divideParam.trainRatio = 1; 
net_ff.divideParam.testRatio  = 0; 
net_ff.divideParam.valRatio   = 0;
 
net_ff.trainParam.epochs = 200;
net_ff.trainParam.goal = 0.00001;
for iL = 1: size(neuronsXLayer,2)
    net_ff.layers{iL}.transferFcn = neuronTransferFcn{iL}; 
end
 
% Train the created neural network and analyze the results

%Training:
net_ff = train (net_ff, X_train, Y_train); 
 
% Test the accuracy
 
%Test:
Y_nn = net_ff(X_val);
% It is sufficient to call the object net_ff
% Input and output are matrices!!!
 
 
% Plot the results
figure  
scatter3(X_train(1,:),X_train(2,:), Y_train)% training samples
hold on ;     
scatter3(X_val(1,:),X_val(2,:), Y_nn); hold off  % estimated values
 
 
% Numerical results
errorT= sum(abs( net_ff(X_train)-Y_train) ) /size(Y_train,2);
errorV= sum(abs( net_ff(X_val)- Y_val) ) /size(Y_val,2);
 
disp(' ---------------------------------------------------------')
disp(' -----TRAINIG ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',errorT);
disp(' -----VALIDATION ERROR-------------------')
fprintf('Mean Absolute Error: %6.4f \n',errorV);
disp(' ---------------------------------------------------------')


