close all, clear variables

RandStream.setGlobalStream (RandStream ('mrg32k3a','Seed', 1234));
% Load and analyze data

load('1Ddata.mat ');

% Create a neural network and tune parameters

numLayers=[1,2,3,4,5,6];

epochs=500;

for i=1:numel(numLayers)  
    totalNeurons = 60;
    for j=1:numLayers(i)
        neuronsXLayer(j)=totalNeurons/numLayers(i);
        neuronTransferFcn{i} = 'logsig';
    end
    
    
    net_ff = feedforwardnet(neuronsXLayer);
    
    
    % training and testing data
    net_ff.divideParam.trainRatio = 1;
    net_ff.divideParam.testRatio  = 0;
    net_ff.divideParam.valRatio   = 0;
    
    net_ff.trainParam.epochs = epochs;
    net_ff.trainParam.goal = 0.00001;
    for iL = 1: size(neuronsXLayer,2)
        net_ff.layers{iL}.transferFcn = neuronTransferFcn{iL};
    end
    
    % Train the created neural network and analyze the results
    
    %Training:
    net_ff = train (net_ff, X_train, Y_train);
    
   
    % Test the accuracy
    
    %Test:
    Y_nn = net_ff(X_val);
    % It is sufficient to call the object net_ff
    % Input and output are matrices!!!
    
    
    
    % Numerical results
    errorT(i)= sum(abs( net_ff(X_train)-Y_train) ) /size(Y_train,2);
    errorV(i)= sum(abs( net_ff(X_val)- Y_val) ) /size(Y_val,2);
    
        
    
end

figure, plot(numLayers,errorT);
hold on
plot(numLayers,errorV);
xlabel('numNeurons');
ylabel('MAE');
legend('Training error','Test error');
