function state = gaplotCircleVisualizer(options, state, flag, stars)
%  GAPLOTCHANGE Plots the logarithmic change in the best score from the previous
% generation.  
NOP = 100;
axis square;
% plot stars:
scatter(stars(:,1),stars(:,2),'x');
hold on


population=state.Population;
[bestFVal,bestFValIndex]=min(state.Score);
%population:
popH = scatter(population(:,1),population(:,2),'o');

% best circle found up to now:
THETA=linspace(0,2*pi,NOP);
RHO=ones(1,NOP)*bestFVal;
[circX,circY] = pol2cart(THETA,RHO);
circX=circX+population(bestFValIndex,1);
circY=circY+population(bestFValIndex,2);
circH = plot(circX,circY,'b-');

title(['X: ' num2str(population(bestFValIndex,1)) '; Y: ' num2str(population(bestFValIndex,2)) '; Radius: ' num2str(bestFVal)]);
xlabel('X');
ylabel('Y');
hold off
drawnow;

