clear variables;

load lab4.mat


param.star=star1;
FitnessFunction = @(x)ObjFunGA_example2(x,[0 20;0 20],param);
numberOfVariables = 2;

% [X,Y]=meshgrid(0:0.05:20,0:0.05:20);
% for i=1:size(X,1)
%     for j=1:size(X,2)
%         Z(i,j)=FitnessFunction([X(i,j) Y(i,j)]);
%     end
% end
% 
% [row, col]=find(Z==min(Z(:)));
% globalOptimumX=X(row,col);
% globalOptimumY=Y(row,col);

% indicate bounds of variables
opts.InitialPopulationRange = [0 0; 20 20];

%indicate selection function
opts.SelectionFcn=@selectionroulette;

% indicate size of population
opts.PopulationSize=50;

% indicate maximum number of generations
opts.Generations=100;

% indicate pcross
opts.CrossoverFraction=1;

%indicate mutation parameters
mutationFraction=0.03;
opts.MutationFcn= {@mutationuniform, mutationFraction};

% indicate number of elite population members
opts.EliteCount=1;

% define a custom visualization function
opts.PlotFcns = @(x,y,z)gaplotCircleVisualizer(x,y,z,param.star);

% indicate the interval to update the plot
opts.PlotInterval=1;


[x,fval,exitflag,output,final_pop,scores] = ga(FitnessFunction,numberOfVariables,[],[],[],[],[0 0],[20 20],[],opts);

