clear variables;
close all;


%plot the function
h=figure;
[X,Y]=meshgrid(0:0.01:1,0:0.1:13);

for i=1:size(X,1)
    for j=1:size(X,2)
        Z(i,j) = 100 * (X(i,j)^2 - Y(i,j)) ^2 + (1 - X(i,j))^2;
    end
end

surfc(X,Y,Z)
hold on;


for i=1:size(X,1)
    for j=1:size(X,2)
        satisfyConstraint1(i,j) = (1.5 + X(i,j)*Y(i,j) + X(i,j) - Y(i,j))<=0;
    end
end

for i=1:size(X,1)
    for j=1:size(X,2)
        satisfyConstraint2(i,j) = (-X(i,j)*Y(i,j) + 10)<=0;
    end
end

satisfyBothConstraints=satisfyConstraint1&satisfyConstraint2;

Xsatisfy=X(satisfyBothConstraints);
Ysatisfy=Y(satisfyBothConstraints);
Zsatisfy=Z(satisfyBothConstraints);
scatter3(Xsatisfy,Ysatisfy,Zsatisfy,'r*');


%%%%%%define GA
FitnessFunction = @ObjFunGA_example3;
ConstrainsFunction=@constraints_example3;

numberOfVariables=2;


% indicate bounds of variables
opts.InitialPopulationRange = [0 0; 1 13];

%indicate selection function
tournamentSize=6;
opts.SelectionFcn=@selectionstochunif;%@selectionroulette;{@selectiontournament,tournamentSize};%

% indicate size of population
opts.PopulationSize=50;

% indicate maximum number of generations
opts.Generations=100;

% indicate pcross
opts.CrossoverFraction=0.6;

%indicate mutation parameters
opts.MutationFcn= @mutationadaptfeasible;

% indicate number of elite population members
opts.EliteCount=5;

% define a custom visualization function
opts.PlotFcns = @gaplotbestf;%@(x,y,z)gaplotCircleVisualizer(x,y,z,param.star);
% 
% % indicate the interval to update the plot
opts.PlotInterval=20;

figure
[x,fval,exitflag,output,final_pop,scores] = ga(FitnessFunction,numberOfVariables,[],[],[],[],[0 0],[1 13],ConstrainsFunction,opts);

figure(h)
scatter3(x(1),x(2),fval,'bo');

