img = imread('skull.tif');
% Cast the input image in double with a range from 0 to 1
img = double(img);
img = img ./ max(img(:));
 
dimY = size(img,1);
dimX = size(img,2);
 
figure
imshow(img,[])
title('Input Image')
 
% Computation of the gradient module
[FX,FY] = gradient(double(img));
gradModule = sqrt((FX.^2)+(FY.^2));


figure
imshow(gradModule,[])
title('Gradient Module')

imgGFuzzy4 = zeros(dimY, dimX);
 
gradiente4 = readfis('gradiente4B.fis')
 
% Analysis of every pixel
for i = 2 : dimY-1
    fprintf('Column %i of %i \n', i, dimY-1)
    for j = 2 : dimX-1
        imgGFuzzy4(i,j) = evalfis([img(i-1, j), img(i, j-1), img(i+1, j), img(i, j+1)], gradiente4);
    end
end
 
figure
imshow(imgGFuzzy4,[])
title('Fuzzy Gradient 4')

imgGFuzzy8 = zeros(dimY, dimX);

gradiente8 = readfis('gradiente8B.fis')

for i = 2 : dimY-1
    fprintf('Column %i of %i \n', i, dimY-1)
    for j = 2 : dimX-1
        matriceMom = img(i-1 : i+1, j-1 : j+1);
        imgGFuzzy8(i,j) = evalfis(matriceMom(:), gradiente8);
    end
end

figure
imshow(imgGFuzzy8,[])
title('Gradiente fuzzy 8')



