clear variables;
close all;

% Train set
train_indata = 6*rand(100,3);
output_train=(1+train_indata(:,1).^0.5+  train_indata(:,2).^1+ train_indata(:,3).^(-1.5));
train_data = [train_indata output_train];
% Test set
test_indata = 6*rand(100,3);
output_test=(1+test_indata(:,1).^0.5+ test_indata(:,2).^1+ test_indata(:,3).^(-1.5));
test_data = [test_indata output_test];
% Plot
figure
subplot(4,1,1), plot(train_indata(:,1))
title('Input x training')
subplot(4,1,2), plot(train_indata(:,2))
title('Input y training')
subplot(4,1,3), plot(train_indata(:,3))
title('Input z training')
subplot(4,1,4), plot(output_train(:,1))
title('Output training')

figure
subplot(4,1,1), plot(test_indata(:,1))
title('Input x testing')
subplot(4,1,2), plot(test_indata(:,2))
title('Input y testing')
subplot(4,1,3), plot(test_indata(:,3))
title('Input z testing')
subplot(4,1,4), plot(output_test(:,1))
title('Output testing')

% Save
save('multiDimData.mat', 'train_data', 'test_data');

% approx multidim 2 2 2 2 sets triangular, linear, 50 epochs

