% approx erf 3 sets gbell, linear, 100 epochs

% Analysis of the results
% Load
load ('erfData');
myFIS = readfis('ApproxErf');
% Execute the FIS
out_Train = evalfis(train_data(:,1),myFIS);
out_Test = evalfis(test_data(:,1),myFIS);
% Data comparison
xTarget= 0: 0.05 : 5;
yTarget = erf(xTarget);
% Plot
figure
plot(xTarget, yTarget, 'g');
hold on
plot (train_data(:,1), out_Train, 'x')
plot (test_data(:,1), out_Test, 'or')
legend('RealData', 'TrainOutput', 'TestOutput')
% Statistics
meanErrorTrain = mean(abs(train_data(:,2) - out_Train));
meanErrorTest = mean(abs(test_data(:,2) - out_Test));
varErrorTrain = var(abs(train_data(:,2) - out_Train));
varErrorTest = var(abs(test_data(:,2) - out_Test));
