img = imread('cell.jpg');

% Cast the input image in double with a range from 0 to 1
img = double(rgb2gray(img));
img = img ./ max(img(:));

dimY = size(img,1);
dimX = size(img,2);

figure
imshow(img,[])
title('Input Image')

% histogram equalization
imgEq = histeq(img);
figure, imshow(imgEq,[])
title('Histogram Equalization'); 

backgroundImg = zeros(dimY, dimX);

background = readfis('background.fis');

% Local mean and std
meanI= colfilt(img,[3 3],'sliding',@mean);
stdI= colfilt(img,[3 3],'sliding',@std);

% Analysis of every pixel
for i = 1 : dimY
    for j = 1 : dimX
        backgroundImg(i,j) = evalfis([img(i,j) meanI(i,j), stdI(i,j)], background);
    end
end

figure
imshow(backgroundImg,[])
title('Fuzzy Backgroungd')
